
/****************************************************************************/
/*									    */
/*				CTYP40					    */
/*				-----					    */
/*									    */
/*   CTYP40.H  -  macros to classify ASCII-coded integers by table lookup.  */
/*									    */
/*									    */
/*	Note:	Integer args are undefined for all int values > 127,	    */
/*		except for macro 'isascii()'.				    */
/*	Assumes:							    */
/*		User will link with standard library functions.		    */
/*		Compiler can handle declarator initializers and		    */
/*		'#defines' with parameters.				    */
/*									    */
/****************************************************************************/

/*
 *	Bit patterns for character class DEFINEs
 */
#define	__c	01
#define	__p	02
#define	__d	04
#define	__u	010
#define	__l	020
#define	__s	040
#define	__cs	041
#define	__ps	042

GLOBAL char	__atab[] = {
	0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,
	0x8,0x9,0xa,0xb,0xc,0xd,0xe,0xf,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
	0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
	0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
	0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
	0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,
	0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
	0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,
	0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f	};

/*
 *	Character Class Testing and Conversion DEFINEs:
 */
#define	isascii(ch) ((ch) < 0200)
#define	isalpha(ch) (__atab[ch] & (__u | __l))
#define	isupper(ch) (__atab[ch] & __u)
#define	islower(ch) (__atab[ch] & __l)
#define	isdigit(ch) (__atab[ch] & __d)
#define	isalnum(ch) (__atab[ch] & (__u | __l | __d))
#define	isspace(ch) (__atab[ch] & __s)
#define	ispunct(ch) (__atab[ch] & __p)
#define	isprint(ch) (__atab[ch] & (__u | __l | __d | __p))
#define	iscntrl(ch) (__atab[ch] & __c)

#define	tolower(ch) (isupper(ch) ? (ch)+('a'-'A') : (ch))
#define	toupper(ch) (islower(ch) ? (ch)+('A'-'a') : (ch))
#define	toascii(ch) ((ch) & 0177)

