;*******************************************************************************
;*                                  z80em86                                    *
;*           A Z80 CPU emulator coded in Intel 86 assembly language            *
;*                                                                             *
;*                             Bit Reset Group                                 *
;*                                                                             *
;*                    Copyright (C) 1992-2009 Stewart Kay                      *
;*******************************************************************************
;
;===============================================================================
; ChangeLog (most recent entries are at top)
;===============================================================================
; v1.0.0 - 10 February 2009, S.J.Kay
; - Convert sources from TASM to NASM format and prepare for GPL release.
; - Changed all uses of 'Z80' map segment to 'es:Z80'
; - Added 'align=16' to all SEGMENT declarations. (nasm def is align=1)
;
; v1.00 - 29 April 1995 S.J.Kay
; - Last time code was worked on before releasing under the GPL.
;
; v0.00 - 1992 S.J.Kay
; - Started to code the Z80 emulator.

;===============================================================================
; z80em86 - A Z80 CPU emulator coded in Intel 86 assembly language.
; Copyright (C) 1992-2009 Stewart Kay
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;===============================================================================

SEGMENT	Z80map	public align=16
Z80:

SEGMENT	.code	public align=16

GLOBAL	Z_RES0w, Z_RES1w, Z_RES2w, Z_RES3w, Z_RES4w, Z_RES5w, Z_RES6w, Z_RES7w
GLOBAL	Z_RES0v, Z_RES1v, Z_RES2v, Z_RES3v, Z_RES4v, Z_RES5v, Z_RES6v, Z_RES7v
GLOBAL	Z_RES0b, Z_RES0c, Z_RES0d, Z_RES0e, Z_RES0h, Z_RES0l, Z_RES0z, Z_RES0a
GLOBAL	Z_RES1b, Z_RES1c, Z_RES1d, Z_RES1e, Z_RES1h, Z_RES1l, Z_RES1z, Z_RES1a
GLOBAL	Z_RES2b, Z_RES2c, Z_RES2d, Z_RES2e, Z_RES2h, Z_RES2l, Z_RES2z, Z_RES2a
GLOBAL	Z_RES3b, Z_RES3c, Z_RES3d, Z_RES3e, Z_RES3h, Z_RES3l, Z_RES3z, Z_RES3a
GLOBAL	Z_RES4b, Z_RES4c, Z_RES4d, Z_RES4e, Z_RES4h, Z_RES4l, Z_RES4z, Z_RES4a
GLOBAL	Z_RES5b, Z_RES5c, Z_RES5d, Z_RES5e, Z_RES5h, Z_RES5l, Z_RES5z, Z_RES5a
GLOBAL	Z_RES6b, Z_RES6c, Z_RES6d, Z_RES6e, Z_RES6h, Z_RES6l, Z_RES6z, Z_RES6a
GLOBAL	Z_RES7b, Z_RES7c, Z_RES7d, Z_RES7e, Z_RES7h, Z_RES7l, Z_RES7z, Z_RES7a

; declared in INSTHAND.ASM
EXTERN  Z80IX, Z80IY

%include "macros.asm"

;***********************************************************
;*      RES     0,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES0b:
        lahf
        and     ch,11111110b
        XinstB

;***********************************************************
;*      RES     1,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES1b:
        lahf
        and     ch,11111101b
        XinstB

;***********************************************************
;*      RES     2,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES2b:
        lahf
        and     ch,11111011b
        XinstB

;***********************************************************
;*      RES     3,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES3b:
        lahf
        and     ch,11110111b
        XinstB

;***********************************************************
;*      RES     4,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES4b:
        lahf
        and     ch,11101111b
        XinstB

;***********************************************************
;*      RES     5,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES5b:
        lahf
        and     ch,11011111b
        XinstB

;***********************************************************
;*      RES     6,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES6b:
        lahf
        and     ch,10111111b
        XinstB

;***********************************************************
;*      RES     7,B              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES7b:
        lahf
        and     ch,01111111b
        XinstB

;***********************************************************
;*      RES     0,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES0c:
        lahf
        and     cl,11111110b
        XinstB

;***********************************************************
;*      RES     1,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES1c:
        lahf
        and     cl,11111101b
        XinstB

;***********************************************************
;*      RES     2,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES2c:
        lahf
        and     cl,11111011b
        XinstB

;***********************************************************
;*      RES     3,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES3c:
        lahf
        and     cl,11110111b
        XinstB

;***********************************************************
;*      RES     4,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES4c:
        lahf
        and     cl,11101111b
        XinstB

;***********************************************************
;*      RES     5,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES5c:
        lahf
        and     cl,11011111b
        XinstB

;***********************************************************
;*      RES     6,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES6c:
        lahf
        and     cl,10111111b
        XinstB

;***********************************************************
;*      RES     7,C              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES7c:
        lahf
        and     cl,01111111b
        XinstB

;***********************************************************
;*      RES     0,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES0d:
        lahf
        and     dh,11111110b
        XinstB

;***********************************************************
;*      RES     1,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES1d:
        lahf
        and     dh,11111101b
        XinstB

;***********************************************************
;*      RES     2,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES2d:
        lahf
        and     dh,11111011b
        XinstB

;***********************************************************
;*      RES     3,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES3d:
        lahf
        and     dh,11110111b
        XinstB

;***********************************************************
;*      RES     4,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES4d:
        lahf
        and     dh,11101111b
        XinstB

;***********************************************************
;*      RES     5,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES5d:
        lahf
        and     dh,11011111b
        XinstB

;***********************************************************
;*      RES     6,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES6d:
        lahf
        and     dh,10111111b
        XinstB

;***********************************************************
;*      RES     7,D              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES7d:
        lahf
        and     dh,01111111b
        XinstB

;***********************************************************
;*      RES     0,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES0e:
        lahf
        and     dl,11111110b
        XinstB

;***********************************************************
;*      RES     1,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES1e:
        lahf
        and     dl,11111101b
        XinstB

;***********************************************************
;*      RES     2,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES2e:
        lahf
        and     dl,11111011b
        XinstB

;***********************************************************
;*      RES     3,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES3e:
        lahf
        and     dl,11110111b
        XinstB

;***********************************************************
;*      RES     4,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES4e:
        lahf
        and     dl,11101111b
        XinstB

;***********************************************************
;*      RES     5,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES5e:
        lahf
        and     dl,11011111b
        XinstB

;***********************************************************
;*      RES     6,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES6e:
        lahf
        and     dl,10111111b
        XinstB

;***********************************************************
;*      RES     7,E              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES7e:
        lahf
        and     dl,01111111b
        XinstB

;***********************************************************
;*      RES     0,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES0h:
        lahf
        and     bh,11111110b
        XinstB

;***********************************************************
;*      RES     1,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES1h:
        lahf
        and     bh,11111101b
        XinstB

;***********************************************************
;*      RES     2,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES2h:
        lahf
        and     bh,11111011b
        XinstB

;***********************************************************
;*      RES     3,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES3h:
        lahf
        and     bh,11110111b
        XinstB

;***********************************************************
;*      RES     4,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES4h:
        lahf
        and     bh,11101111b
        XinstB

;***********************************************************
;*      RES     5,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES5h:
        lahf
        and     bh,11011111b
        XinstB

;***********************************************************
;*      RES     6,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES6h:
        lahf
        and     bh,10111111b
        XinstB

;***********************************************************
;*      RES     7,H              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES7h:
        lahf
        and     bh,01111111b
        XinstB

;***********************************************************
;*      RES     0,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES0l:
        lahf
        and     bl,11111110b
        XinstB

;***********************************************************
;*      RES     1,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES1l:
        lahf
        and     bl,11111101b
        XinstB

;***********************************************************
;*      RES     2,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES2l:
        lahf
        and     bl,11111011b
        XinstB

;***********************************************************
;*      RES     3,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES3l:
        lahf
        and     bl,11110111b
        XinstB

;***********************************************************
;*      RES     4,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES4l:
        lahf
        and     bl,11101111b
        XinstB

;***********************************************************
;*      RES     5,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES5l:
        lahf
        and     bl,11011111b
        XinstB

;***********************************************************
;*      RES     6,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES6l:
        lahf
        and     bl,10111111b
        XinstB

;***********************************************************
;*      RES     7,L              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES7l:
        lahf
        and     bl,01111111b
        XinstB

;***********************************************************
;*      RES     0,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES0a:
        lahf
        and     al,11111110b
        XinstB

;***********************************************************
;*      RES     1,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES1a:
        lahf
        and     al,11111101b
        XinstB

;***********************************************************
;*      RES     2,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES2a:
        lahf
        and     al,11111011b
        XinstB

;***********************************************************
;*      RES     3,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES3a:
        lahf
        and     al,11110111b
        XinstB

;***********************************************************
;*      RES     4,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES4a:
        lahf
        and     al,11101111b
        XinstB

;***********************************************************
;*      RES     5,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES5a:
        lahf
        and     al,11011111b
        XinstB

;***********************************************************
;*      RES     6,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES6a:
        lahf
        and     al,10111111b
        XinstB

;***********************************************************
;*      RES     7,A              Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES7a:
        lahf
        and     al,01111111b
        XinstB

;***********************************************************
;*      RES     0,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES0z:
        lahf
        and     BYTE [es:Z80+bx],11111110b
        XinstB

;***********************************************************
;*      RES     1,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES1z:
        lahf
        and     BYTE [es:Z80+bx],11111101b
        XinstB

;***********************************************************
;*      RES     2,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES2z:
        lahf
        and     BYTE [es:Z80+bx],11111011b
        XinstB

;***********************************************************
;*      RES     3,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES3z:
        lahf
        and     BYTE [es:Z80+bx],11110111b
        XinstB

;***********************************************************
;*      RES     4,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES4z:
        lahf
        and     BYTE [es:Z80+bx],11101111b
        XinstB

;***********************************************************
;*      RES     5,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES5z:
        lahf
        and     BYTE [es:Z80+bx],11011111b
        XinstB

;***********************************************************
;*      RES     6,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES6z:
        lahf
        and     BYTE [es:Z80+bx],10111111b
        XinstB

;***********************************************************
;*      RES     7,(HL)           Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES7z:
        lahf
        and     BYTE [es:Z80+bx],01111111b
        XinstB

;***********************************************************
;*      RES     0,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      RES     0,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES0w:
Z_RES0v:
        lahf
        and     BYTE [es:Z80+si],11111110b
        XinstB

;***********************************************************
;*      RES     1,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      RES     1,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES1w:
Z_RES1v:
        lahf
        and     BYTE [es:Z80+si],11111101b
        XinstB

;***********************************************************
;*      RES     2,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      RES     2,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES2w:
Z_RES2v:
        lahf
        and     BYTE [es:Z80+si],11111011b
        XinstB

;***********************************************************
;*      RES     3,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      RES     3,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES3w:
Z_RES3v:
        lahf
        and     BYTE [es:Z80+si],11110111b
        XinstB

;***********************************************************
;*      RES     4,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      RES     4,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES4w:
Z_RES4v:
        lahf
        and     BYTE [es:Z80+si],11101111b
        XinstB

;***********************************************************
;*      RES     5,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      RES     5,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES5w:
Z_RES5v:
        lahf
        and     BYTE [es:Z80+si],11011111b
        XinstB

;***********************************************************
;*      RES     6,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      RES     6,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES6w:
Z_RES6v:
        lahf
        and     BYTE [es:Z80+si],10111111b
        XinstB

;***********************************************************
;*      RES     7,(IX+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;*      RES     7,(IY+NN)        Flags: S Z - H - P/V N C  *
;*                                      . . x . x  .  . .  *
;***********************************************************
Z_RES7w:
Z_RES7v:
        lahf
        and     BYTE [es:Z80+si],01111111b
        XinstB

        end
