(*  VERSION 0026 *)

(* 5.5 STARTS WITH VERSION 26 *)

MODULE PPINIT;

(*$I PPTYPES*)

(*$I PPEXTS*)

EXTERNAL PROCEDURE GETCHAR;

EXTERNAL PROCEDURE GETSYMBOL(VAR NEXTSYM,CURRSYM : SYMBOLINFO);
PROCEDURE INITIALIZE;

PROCEDURE IDINIT;
BEGIN
  KEYWORD[PROGSY  ] := 'PROGRAM   ' ;
  KEYWORD[EXTSY   ] := 'EXTERNAL  ' ;
  KEYWORD[FUNCSY  ] := 'FUNCTION  ' ;
  KEYWORD[PROCSY  ] := 'PROCEDURE ' ;
  KEYWORD[LABELSY ] := 'LABEL     ' ;
  KEYWORD[CONSTSY ] := 'CONST     ' ;
  KEYWORD[TYPESY  ] := 'TYPE      ' ;
  KEYWORD[VARSY   ] := 'VAR       ' ;
  KEYWORD[BEGINSY ] := 'BEGIN     ' ;
  KEYWORD[REPEATSY] := 'REPEAT    ' ;
  KEYWORD[RECORDSY] := 'RECORD    ' ;
  KEYWORD[CASESY  ] := 'CASE      ' ;
  KEYWORD[CASEVARSY]:= 'CASE      ' ;
  KEYWORD[OFSY    ] := 'OF        ' ;
  KEYWORD[FORSY   ] := 'FOR       ' ;
  KEYWORD[WHILESY ] := 'WHILE     ' ;
  KEYWORD[WITHSY  ] := 'WITH      ' ;
  KEYWORD[DOSY    ] := 'DO        ' ;
  KEYWORD[IFSY    ] := 'IF        ' ;
  KEYWORD[THENSY  ] := 'THEN      ' ;
  KEYWORD[ELSESY  ] := 'ELSE      ' ;
  KEYWORD[ENDSY   ] := 'END       ' ;
  KEYWORD[UNTILSY ] := 'UNTIL     ' ;

  TOP := 0;
  CURLINEPOS := 0;
  CURRMARGIN := 0;
  DBLCHARS := [BECOMES,OPENCOMMENT];
  
  DBLCHR[BECOMES    ] := ':=';
  DBLCHR[OPENCOMMENT] := '(*';
  
  SGLCHAR[OPENCOMMENT] := '{';
  SGLCHAR[CLOSECOMMENT] := '}';
  SGLCHAR[SEMICOLON ] := ';';
  SGLCHAR[COLON     ] := ':';
  SGLCHAR[EQUALS    ] := '=';
  SGLCHAR[OPENPAREN ] := '(';
  SGLCHAR[CLOSEPAREN] := ')';
  SGLCHAR[PERIOD    ] := '.';

  RECORDSEEN := FALSE;
  COLONSEEN := FALSE;

  FILLCHAR(CUR,SIZEOF(CHARINFO),CHR(0));
  NXT := CUR;
  
  GETCHAR;
  
{-----------------
  NEW(CURRSYM);
  NEW(NEXTSYM);
------------------}
  
  GETSYMBOL(NEXTSYM,CURRSYM);
  
END; (* IDINIT *)

PROCEDURE PPOPTINIT;

  PROCEDURE PP1;
  BEGIN
  
  WITH PPOPTION[PROGSY] DO
    BEGIN
      OPT := [BLANKLINEBEFORE, SPACEAFTER];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := [];
    END;
    
  WITH PPOPTION[ EXTSY ] DO
    BEGIN
      OPT := [BLANKLINEBEFORE, SPACEAFTER];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := []
    END;

  WITH PPOPTION[FUNCSY] DO
    BEGIN
      OPT := [BLANKLINEBEFORE,DINDENTONKEYS,SPACEAFTER];
      DINDENTSYMBOLS := [LABELSY,CONSTSY,TYPESY];
      GOBBLETERMINATORS := []
    END;

  WITH PPOPTION[PROCSY] DO
    BEGIN
      OPT := [BLANKLINEBEFORE, DINDENTONKEYS, SPACEAFTER];
      DINDENTSYMBOLS := [ LABELSY, CONSTSY, TYPESY, VARSY ];
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ LABELSY ] DO
    BEGIN
      OPT := [CRBEFORE, SPACEAFTER, INDENTTOCLP ];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ CONSTSY ] DO
    BEGIN
      OPT := [ CRBEFORE, DINDENTONKEYS, SPACEAFTER, INDENTTOCLP ];
      DINDENTSYMBOLS := [ LABELSY ] ;
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ TYPESY ] DO
    BEGIN
      OPT := [ CRBEFORE, DINDENTONKEYS, SPACEAFTER, INDENTTOCLP ];
      DINDENTSYMBOLS := [ LABELSY, CONSTSY ] ;
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ VARSY ] DO
    BEGIN
      OPT := [CRBEFORE, DINDENTONKEYS, SPACEAFTER, INDENTTOCLP ];
      DINDENTSYMBOLS := [LABELSY, CONSTSY, TYPESY ];
      GOBBLETERMINATORS := [];
    END;
    
  WITH PPOPTION [ BEGINSY ] DO
    BEGIN
      OPT := [DINDENTONKEYS, INDENTBYTAB, CRAFTER];
      DINDENTSYMBOLS := [LABELSY, CONSTSY, TYPESY, VARSY ] ;
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION[ REPEATSY ] DO
    BEGIN
      OPT := [INDENTBYTAB, CRAFTER ];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ RECORDSY ] DO
    BEGIN
      OPT := [INDENTBYTAB, CRAFTER];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ CASESY ] DO
    BEGIN
      OPT := [SPACEAFTER, INDENTBYTAB, GOBBLESYMBOLS, CRAFTER];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := [OFSY]
    END;
    
  WITH PPOPTION [ CASEVARSY ] DO
    BEGIN
      OPT := [SPACEAFTER, INDENTBYTAB, GOBBLESYMBOLS, CRAFTER ];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := [OFSY]
    END;
    
  WITH PPOPTION [ OFSY ] DO
    BEGIN
      OPT := [CRSUPPRESS, SPACEBEFORE ] ;
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := [ OFSY ]
    END;
    
  WITH PPOPTION [ FORSY ] DO
    BEGIN
      OPT := [SPACEAFTER, INDENTBYTAB, GOBBLESYMBOLS, CRAFTER];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := [DOSY]
    END;
    
  WITH PPOPTION [ WHILESY ] DO
    BEGIN
      OPT := [SPACEAFTER, INDENTBYTAB, GOBBLESYMBOLS, CRAFTER ] ;
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := [DOSY];
    END;
    
  WITH PPOPTION [ WITHSY ] DO
    BEGIN
      OPT := [SPACEAFTER, INDENTBYTAB, GOBBLESYMBOLS, CRAFTER ];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := [ DOSY ];
    END;
    
  WITH PPOPTION [ DOSY ] DO
    BEGIN
      OPT := [CRSUPPRESS, SPACEBEFORE ];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ IFSY ] DO
    BEGIN
      OPT := [SPACEAFTER, INDENTBYTAB, GOBBLESYMBOLS];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := [THENSY]
    END;
    
  END; (* PP1 *)
  

  PROCEDURE PP2;
  BEGIN
  

  WITH PPOPTION [ THENSY] DO
    BEGIN
      OPT := [SPACEBEFORE, CRAFTER ];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ ELSESY ] DO
    BEGIN
      OPT := [CRBEFORE, DINDENTONKEYS, {DINDENT,} INDENTBYTAB, CRAFTER ];
      DINDENTSYMBOLS := [IFSY,ELSESY];
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ ENDSY ] DO
    BEGIN
      OPT := [CRBEFORE, DINDENTONKEYS, DINDENT, CRAFTER ];
      DINDENTSYMBOLS := [IFSY,THENSY,ELSESY,FORSY, WHILESY, WITHSY,
                         CASEVARSY,COLON, EQUALS];
    END;
    
  WITH PPOPTION [ UNTILSY ] DO
    BEGIN
      OPT := [ CRBEFORE, DINDENTONKEYS, DINDENT, SPACEAFTER, GOBBLESYMBOLS,
               CRAFTER];
      DINDENTSYMBOLS := [ IFSY, THENSY, ELSESY, FORSY, 
                        WHILESY, WITHSY, COLON, EQUALS ] ;
      GOBBLETERMINATORS := [ ENDSY, UNTILSY, ELSESY, SEMICOLON ] 
    END;
    
  WITH PPOPTION [ BECOMES ] DO
    BEGIN
      OPT := [ SPACEBEFORE, SPACEAFTER, GOBBLESYMBOLS ] ;
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := [ ENDSY, UNTILSY, ELSESY, SEMICOLON ]
    END;
    
  WITH PPOPTION [ CLOSECOMMENT ] DO
    BEGIN
      OPT := [CRSUPPRESS];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := [];
    END;
    
  WITH PPOPTION [ SEMICOLON ] DO
    BEGIN
      OPT := [CRSUPPRESS, DINDENTONKEYS, CRAFTER];
      DINDENTSYMBOLS := [IFSY, THENSY, ELSESY, FORSY, WHILESY,
                         WITHSY, COLON, EQUALS ] ;
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ COLON ] DO
    BEGIN
      OPT := [SPACEAFTER, INDENTTOCLP ] ;
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := [];
    END;
    
  WITH PPOPTION [ EQUALS ] DO
    BEGIN
      OPT := [SPACEBEFORE, SPACEAFTER, INDENTTOCLP ] ;
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ OPENPAREN ] DO
    BEGIN
      OPT := [GOBBLESYMBOLS ] ;
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := [CLOSEPAREN]
    END;
    
  WITH PPOPTION [ CLOSEPAREN ] DO
    BEGIN
      OPT := [];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ PERIOD ] DO
    BEGIN
      OPT := [CRSUPPRESS];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ END_OF_FILE ] DO
    BEGIN
      OPT := [];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := []
    END;
    
  WITH PPOPTION [ ANOTHERSY ] DO
    BEGIN
      OPT := [SPACEAFTER];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := []
    END;

  WITH PPOPTION [ OTHERSY ] DO
    BEGIN
      OPT := [];
      DINDENTSYMBOLS := [];
      GOBBLETERMINATORS := []
    END;

  END; (* PP2 *)
     
  BEGIN (* PPOPTINIT *)
    PP1;
    PP2;
  END; (* PPOPTINIT *)

BEGIN (* INITIALIZE *)

  IDINIT;
  PPOPTINIT;
END; (* INITIALIZE *)


MODEND.


